<!-- Main content -->
<x-admin.contents>
    <x-slot:title>{{ $data['title'] }}</x-slot:title>
    <x-slot:menuOpen>{{ $data['menuOpen'] }} </x-slot:menuOpen>
    <x-slot:menuActive>{{ $data['menuActive'] }} </x-slot:menuActive>
    <x-slot:page>{{ $data['page'] }}</x-slot:page>
    <x-slot:head>
        <link rel="stylesheet" href="{{ asset('assets/') }}/admin/plugins/sweetalert2/sweetalert2.min.css">
        <link rel="stylesheet" href="{{ asset('assets/') }}/admin/plugins/summernote/summernote-bs4.min.css">
        <style>
            div.note-editable {
                height: 250px;
            }
        </style>
    </x-slot:head>


    <section class="content">

        <!-- Default box -->
        <div class="row">
            <div class="col-lg-12">
                <x-message></x-message>
                <div class="card card-primary card-outline">
                    <div class="card-header">
                        <h3 class="card-title"><i class="fa fa-server text-primary"></i> {{ $data['page'] }}</h3>
                    </div>

                    <form action="{{ route('produk.store') }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6">

                                    <div class="form-group row">
                                        <label for="inputPassword3" class="col-sm-4 col-form-label">Barcode / Kode
                                            Produk</label>
                                        <div class="col-sm-8">
                                            <input type="text" name="kd_produk" class="form-control numbers"
                                                placeholder="Kode Produk" required value="{{ old('kd_produk') }}">
                                            @error('kd_produk')
                                                <small class="text-danger mt-2">
                                                    {{ $message }}
                                                </small>
                                            @enderror
                                        </div>
                                    </div>

                                    <div class="form-group row">
                                        <label for="inputPassword3" class="col-sm-4 col-form-label">Kategori
                                        </label>
                                        <div class="col-sm-6">
                                            <select name="kategori" id="kategori" class="form-control">
                                                <option value="">Pilih</option>
                                            </select>
                                            @error('kategori')
                                                <small class="text-danger mt-2">
                                                    {{ $message }}
                                                </small>
                                            @enderror
                                        </div>
                                        <div class="col-sm-2">
                                            <button type="button" class="btn btn-primary btn-block "
                                                data-toggle="modal" data-target="#tamkategori"><i
                                                    class="fa fa-plus"></i></button>
                                        </div>
                                    </div>

                                    <div class="form-group row">
                                        <label for="inputPassword3" class="col-sm-4 col-form-label">Nama
                                            Produk</label>
                                        <div class="col-sm-8">
                                            <input type="text" name="nm_produk" class="form-control"
                                                placeholder="Nama Produk" required value="{{ old('nm_produk') }}">
                                            @error('nm_produk')
                                                <small class="text-danger mt-2">
                                                    {{ $message }}
                                                </small>
                                            @enderror
                                        </div>
                                    </div>

                                    <div class="form-group row">
                                        <label for="inputPassword3" class="col-sm-4 col-form-label">Berat Bersih</label>
                                        <div class="col-sm-8">
                                            <input type="text" name="berat" class="form-control numbers"
                                                placeholder="000 Gram" required value="{{ old('berat') }}">
                                            @error('berat')
                                                <small class="text-danger mt-2">
                                                    {{ $message }}
                                                </small>
                                            @enderror
                                        </div>
                                    </div>

                                    <hr>
                                    <h4>HARGA</h4>


                                    <div class="form-group row">
                                        <label for="inputPassword3" class="col-sm-4 col-form-label">Harga Beli</label>
                                        <div class="col-sm-8">
                                            <input type="text" name="harga_beli" class="form-control numbers"
                                                placeholder="Rp. 0" required value="{{ old('harga_beli') }}">
                                            @error('harga_beli')
                                                <small class="text-danger mt-2">
                                                    {{ $message }}
                                                </small>
                                            @enderror
                                        </div>
                                    </div>

                                    <div class="form-group row">
                                        <label for="inputPassword3" class="col-sm-4 col-form-label">Harga Jual</label>
                                        <div class="col-sm-8">
                                            <input type="text" name="harga_jual" class="form-control numbers"
                                                placeholder="Rp. 0" required value="{{ old('harga_jual') }}">
                                            @error('harga_jual')
                                                <small class="text-danger mt-2">
                                                    {{ $message }}
                                                </small>
                                            @enderror
                                        </div>
                                    </div>

                                    <div class="form-group row">
                                        <label for="inputPassword3" class="col-sm-4 col-form-label">Diskon</label>
                                        <div class="col-sm-8">
                                            <input type="text" name="diskon" class="form-control numbers"
                                                placeholder="0%" required value="{{ old('diskon') }}">
                                            @error('diskon')
                                                <small class="text-danger mt-2">
                                                    {{ $message }}
                                                </small>
                                            @enderror
                                        </div>
                                    </div>

                                    <div class="form-group row">
                                        <label for="inputPassword3" class="col-sm-4 col-form-label">Satuan Jual
                                        </label>
                                        <div class="col-sm-6">
                                            <select name="satuan" id="satuan" class="form-control">
                                                <option value="">Pilih</option>
                                            </select>
                                            @error('satuan')
                                                <small class="text-danger mt-2">
                                                    {{ $message }}
                                                </small>
                                            @enderror
                                        </div>
                                        <div class="col-sm-2">
                                            <button type="button" class="btn btn-primary btn-block "
                                                data-toggle="modal" data-target="#tamsatuan"><i
                                                    class="fa fa-plus"></i></button>
                                        </div>
                                    </div>

                                </div>

                                <div class="col-md-6">
                                    <div class="form-group ">
                                        <label for="">Deskripsi</label>
                                        <textarea id="summernote" name="keterangan">  </textarea>
                                        @error('keterangan')
                                            <small class="text-danger mt-2">
                                                {{ $message }}
                                            </small>
                                        @enderror
                                    </div>

                                    <hr>
                                    <div class="form-group row">
                                        <label for="inputPassword3" class="col-sm-4 col-form-label">File Gambar

                                        </label>
                                        <div class="col-sm-8">
                                            <div class="custom-file">
                                                <input type="file" name="gambar" class="custom-file-input"
                                                    id="exampleInputFile">
                                                <label class="custom-file-label" for="exampleInputFile">Cari
                                                    file</label>
                                                @error('gambar')
                                                    <small class="text-danger mt-2">
                                                        {{ $message }}
                                                    </small>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>


                                    <div class="form-group row">
                                        <label for="inputPassword3" class="col-sm-4 col-form-label">(jpg,jpeg,png)

                                        </label>
                                        <div class="col-sm-8">
                                            <div style="height: 180px; width: 40%; border:1px solid  #eaedf0"
                                                class="gambar"></div>
                                        </div>
                                    </div>



                                </div>

                            </div>
                        </div>
                        <div class="card-footer">
                            <button type="reset" class="btn btn-default">Reset</button>
                            <button type="submit" class="btn btn-primary float-right"><i class="fa fa-save"></i>
                                Simpan</button>
                        </div>
                    </form>
                </div>
            </div>


        </div>
        <!-- /.card -->

    </section>


    {{-- tambah kategori --}}
    <div class="modal fade" id="tamkategori">
        <div class="modal-dialog ">
            <div class="modal-content">
                <div class="modal-header bg-primary ">
                    Tambah Data Kategori
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label for="">Judul Kategori</label>
                        <input type="text" name="nm_kategori" id="nm_kategori" class="form-control"
                            placeholder="Judul Kategori...">
                    </div>
                    <div class="form-group">
                        <label for="">Keterangan</label>
                        <textarea name="ktr_kategori" id="ktr_kategori" class="form-control"></textarea>
                    </div>
                </div>
                <div class="modal-footer justify-content-between">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    <button type="button" class="btn btn-primary kategori">Simpan</button>
                </div>
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>


    {{-- tambah kategori --}}
    <div class="modal fade" id="tamsatuan">
        <div class="modal-dialog ">
            <div class="modal-content">
                <div class="modal-header bg-primary ">
                    Tambah Data Satuan
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label for="">Nama Satuan</label>
                        <input type="text" name="nm_satuan" id="nm_satuan" class="form-control"
                            placeholder="Nama Satuan...">
                    </div>
                    <div class="form-group">
                        <label for="">Keterangan</label>
                        <textarea name="ktr_satuan" id="ktr_satuan" class="form-control"></textarea>
                    </div>
                </div>
                <div class="modal-footer justify-content-between">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    <button type="button" class="btn btn-primary satuan">Simpan</button>
                </div>
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>




    <x-slot:foot>
        <script src="{{ asset('assets/') }}/admin/plugins/summernote/summernote-bs4.min.js"></script>
        <script src="{{ asset('assets/') }}/admin/plugins/bs-custom-file-input/bs-custom-file-input.min.js"></script>
        <script src="{{ asset('assets/') }}/admin/plugins/sweetalert2/sweetalert2.all.min.js"></script>
        <script>
            $(function() {
                bsCustomFileInput.init();
                $('#summernote').summernote();

                $("#exampleInputFile").change(function() {
                    filePreview(this);
                });

                function filePreview(input) {
                    if (input.files && input.files[0]) {
                        var reader = new FileReader();
                        reader.onload = function(e) {
                            $('#img').remove();
                            $('.gambar').append('<img src="' + e.target.result +
                                '" width="100%" height="180px" id="img">');
                        };
                        reader.readAsDataURL(input.files[0]);
                    }
                }

                $('.kategori').click(function() {
                    var token = $("meta[name='csrf-token']").attr("content");
                    var nm_kategori = $('#nm_kategori').val();
                    var ktr_kategori = $('#ktr_kategori').val();
                    if (nm_kategori == "") {
                        $('#nm_kategori').focus();
                    } else if (ktr_kategori == "") {
                        $('#ktr_kategori').focus();
                    } else {
                        $.ajax({
                            type: 'POST',
                            url: '/simpan-kategori',
                            data: {
                                nm_kategori: nm_kategori,
                                ktr_kategori: ktr_kategori,
                                _token: token,
                            },
                            success: function(data) {
                                $('#tamkategori').modal('hide');
                                $('#nm_kategori').val("");
                                $('#ktr_kategori').val("");
                                kategori();
                                Swal.fire({
                                    icon: "success",
                                    title: "Berhasil",
                                    text: "Data kategori berhasil ditambahkan!",
                                })
                            }
                        });
                    }
                });

                kategori();

                function kategori() {
                    $.ajax({
                        type: 'GET',
                        url: '/view-kategori',
                        success: function(data) {
                            $('#kategori').html(data);
                        }
                    });
                }

                $('.satuan').click(function() {
                    var token = $("meta[name='csrf-token']").attr("content");
                    var nm_satuan = $('#nm_satuan').val();
                    var ktr_satuan = $('#ktr_satuan').val();
                    if (nm_satuan == "") {
                        $('#nm_satuan').focus();
                    } else if (ktr_satuan == "") {
                        $('#ktr_satuan').focus();
                    } else {
                        $.ajax({
                            type: 'POST',
                            url: '/simpan-satuan',
                            data: {
                                nm_satuan: nm_satuan,
                                ktr_satuan: ktr_satuan,
                                _token: token,
                            },
                            success: function(data) {
                                $('#tamsatuan').modal('hide');
                                $('#nm_satuan').val("");
                                $('#ktr_satuan').val("");
                                satuan();
                                Swal.fire({
                                    icon: "success",
                                    title: "Berhasil",
                                    text: "Data Satuan Jual berhasil ditambahkan!",
                                })
                            }
                        });
                    }
                });

                satuan();

                function satuan() {
                    $.ajax({
                        type: 'GET',
                        url: '/view-satuan',
                        success: function(data) {
                            $('#satuan').html(data);
                        }
                    });
                }
            });
        </script>
    </x-slot:foot>
</x-admin.contents>
